/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.dispatch.actionControllers;

import com.aptana.configurations.processor.ConfigurationStatus;
import com.aptana.core.projects.templates.IProjectTemplate;
import com.aptana.core.projects.templates.TemplateType;
import com.aptana.core.util.ResourceUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.jetty.util.epl.ajax.JSON;
import com.aptana.portal.ui.dispatch.actionControllers.AbstractActionController;
import com.aptana.portal.ui.dispatch.actionControllers.ControllerAction;
import com.aptana.projects.ProjectsPlugin;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateActionController
extends AbstractActionController {
    private static final String[] ALL_TYPES = new String[]{TemplateType.PHP.name(), TemplateType.PYTHON.name(), TemplateType.RAILS.name(), TemplateType.RUBY.name(), TemplateType.TITANIUM_DESKTOP.name(), TemplateType.TITANIUM_MOBILE.name(), TemplateType.WEB.name()};

    public void configurationStateChanged(ConfigurationStatus status, Set<String> attributesChanged) {
    }

    @ControllerAction
    public Object getTemplateTypes() {
        return JSON.toString((Object[])ALL_TYPES);
    }

    @ControllerAction
    public Object getTemplates(Object templateTypes) {
        ArrayList<TemplateType> types = new ArrayList<TemplateType>();
        if (!(templateTypes instanceof Object[]) || ((Object[])templateTypes).length < 1) {
            templateTypes = ALL_TYPES;
        }
        Object[] objectArray = templateTypes;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateType templateType;
            Object object = objectArray[n2];
            if (object instanceof String && (templateType = TemplateType.valueOf((String)((String)object))) != null) {
                types.add(templateType);
            }
            ++n2;
        }
        List templates = ProjectsPlugin.getDefault().getTemplatesManager().getTemplates(types.toArray(new TemplateType[types.size()]));
        ArrayList templateObjects = new ArrayList();
        for (IProjectTemplate template : templates) {
            if (template.getId() == null || template.getId().length() == 0) continue;
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put(TEMPLATE_INFO.ID.toString(), template.getId());
            properties.put(TEMPLATE_INFO.NAME.toString(), template.getDisplayName());
            properties.put(TEMPLATE_INFO.DESCRIPTION.toString(), template.getDescription());
            properties.put(TEMPLATE_INFO.TEMPLATE_TYPE.toString(), template.getType().name());
            if (template.getIconURL() != null) {
                URI iconPath = ResourceUtil.resourcePathToURI((URL)template.getIconURL());
                properties.put(TEMPLATE_INFO.IMAGE_URL.toString(), iconPath.toASCIIString());
            }
            properties.put(TEMPLATE_INFO.TAG.toString(), StringUtil.join((String)",", (Collection)template.getTags()));
            templateObjects.add(properties);
        }
        return JSON.toString((Object[])templateObjects.toArray(new Map[templateObjects.size()]));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TEMPLATE_INFO {
        ID("id"),
        NAME("name"),
        DESCRIPTION("description"),
        TEMPLATE_TYPE("type"),
        IMAGE_URL("image"),
        TAG("tag");

        private String key;

        private TEMPLATE_INFO(String key) {
            this.key = key;
        }

        public String toString() {
            return this.key;
        }
    }
}

